//Ex 4.3 Program Title:To Implement gray level slicing with background and without background
///environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
ii1=imread(SIVP_PATH + 'images/rose2.bmp');//read  color image from diractory
im1=rgb2gray(ii1);
[im2,im3]=grayslic(im1);//graylevel slicing
[r,g,b]=colorplanes(ii1)//color planes seperation
[rim2,rim3]=grayslic(r);//graylevel slicing red plane
[gim2,gim3]=grayslic(g);//graylevel slicing green plane
[bim2,bim3]=grayslic(b);//graylevel slicing blue plane
figure(1);ShowColorImage(ii1,'Color image');title('Color image','color','red','fontsize',6);//IPD tool box
figure(2);ShowImage(im1,'Grayscale image');title('Grayscale image','color','red','fontsize',6);//IPD tool box
///////////Gray level slicing with background method //////////////
figure(3);ShowImage(im3,'Gray level slicing with background');title('Gray level slicing with background for grayscale image','color','red','fontsize',4);//IPD tool box
figure(4);ShowImage(rim3,'Gray level slicing with background');title('Gray level slicing with background  for red plane','color','red','fontsize',4);//IPD tool box
figure(5);ShowImage(gim3,'Gray level slicing with background');title('Gray level slicing with background for green plane','color ','red','fontsize',4);//IPD tool box
figure(6);ShowImage(bim3,'Gray level slicing with background');title('Gray level slicing with background for blue plane','color ','red','fontsize',4);//IPD tool box
//////////Gray Level Slicing without Background method//////////////
figure(7);ShowImage(im2,'Gray level slicing without background');title('Gray level slicing without background for grayscale image','color','red','fontsize',4);//IPD tool box
figure(8);ShowImage(rim2,'Gray level slicing without background');title('Gray level slicing without background  for red plane','color','red','fontsize',4);//IPD tool box
figure(9);ShowImage(gim2,'Gray level slicing without background');title('Gray level slicing without background for green plane','color ','red','fontsize',4);//IPD tool box
figure(10);ShowImage(bim2,'Gray level slicing without background');title('Gray level slicing without background for blue plane','color ','red','fontsize',4);//IPD tool box
